.he                 SYSLIB User and Reference Manual
.fo  1 - Introduction                                      Page #
.pn 1



      SYSLIB -- An Integrated Library of Assembly Language
  Utility Subroutines for use with the Microsoft M80 Assembler


1.0  Introduction

1.01 What is SYSLIB?

     SYSLI  (SYSte LIBrary i  collectio o ove 13 subrou
tine whic ar designe t provid t th CP/ 8080/Z8 assembl 
languag programme  se o function upo whic h ca buil 
hi programs  Thi librar i intende t reliev th programme 
o th tas o frequentl "reinventin th wheel an t provid 
hi wit a environmen o reliabl tool whic encourage struc
ture programmin a th assembl languag level.

     Eac subroutin withi SYSLI ca b viewe a  reliabl 
"blac box.  Th subroutine i SYSLI ar completel documente 
withi thi 112 pag manua an th SYSLIBx.HL files an th 
programme i consistentl provide wit th followin informa
tion:
          1.  Name of Subroutine
          2.  Function it performs
          3.  What its inputs are
          4.  What its outputs are
          5.  What registers are affected by it
          6.  What other library routines it calls upon
          7.  What errors can occur and how it handles them

     Th routine withi SYSLI ar designe t wor togethe an 
complemen eac other  Paramete passin i consisten betwee 
th variou subroutines  Fo instance al routine whic nee 
t b passe  pointe t  Fil Contro Bloc ar passe tha 
pointe i th D registe pair  A  genera rule i  regis
te i no returne a a outpu fro th SYSLI subroutine the 
it valu i no affecte (i ha th sam valu whe th routin 
i exite a i ha whe th routin wa called).

     SYSLI  itsel i  librar o relocatabl objec module 
create i th Microsof M8 relocatabl objec format  Al 
subroutine withi SYSLI ar groupe withi functionally-relate 
modules  Onc  routin i reference (b th EX statemen i 
th M8 assembl languag program) it modul i loade an i 
i availabl t th programme b mean o  simpl subroutin 
call  Al othe subroutine withi tha particula modul ar 
als loaded bu the ar no availabl t th programme unles 
h ha als reference the b EX statements  Th modul i 
loade onl once regardles o ho man routine withi th 
modul ar referenced  Fo thi reason  hav designe eac 
modul t contai routine whic ar frequentl use togethe o 
ar calle b eac othe (on routin withi th modul call 
another routine within the module).

1.02 What is Needed to Use SYSLIB?

     Yo nee a 8080- o Z80-base microcompute wit a leas 
48ˠ byte o contiguou memor runnin CP/ 2.2 th Microsof 
M8 assemble too se (specifically th M8 assemble an th 
L8 linker) an th usua se o softwar developmen tool (a 
edito and preferably  debugger t us SYSLIB.



1.03 What Does SYSLIB Buy Me?

     Th botto lin i that t th experience SYSLI program
mer SYSLI ha th potentia o bein  significan too whic 
enable hi to:

          1.  Solve his programming task quickly
               -- becaus h spend les tim writin com
monly-use subroutine an worryin abou ho hi regis
ter ar affecte b thes subroutine an mor tim 
concentratin o th proble a hand

      2.  Write space- and speed-efficient code
           -- becaus al o th SYSLI routine hav 
bee gon ove tim an tim agai t reduc thei siz 
an mak the mor efficien i term o speed fo 
example th SOR routin i  Shel Sor tha ca b 
calle t perfor th sor usin pointer (i whic cas 
i exchange pointer rathe tha record whe i need 
t d  swap o perfor th sor withou usin pointer 
(whe spac i  facto an ther ma no b enoug roo 
fo  pointe table)

      3  Writ mor maintainabl code
           -- becaus SYSLI i designe wit structure 
programmin philosoph i mind eac subroutin i equi
valen t  proces box havin (1 onl on entranc 
an on exit (2  precisely-define function an (3 
 precisely-define se o inpu an outpu parameters 
havin use SYSLI fo som tim now th autho ha 
note tha hi programmin though processe an progra 
design hav tende mor an mor towar end-in (top-
dow fro th objectiv poin o vie an bottom-u fro 
th SYSLI subroutin poin o view) structure design 
tha h ca g bac t a  late dat an readil 
deciphe an modify


      4.  Reduce the programming effort
           -- becaus SYSLI provide  numbe o ver 
involve routine whic would i themselves tak quit 
som tim t code fo example th DIR routin wil 
loa th director o  dis int memory selec  se 
o file fro tha loade director a specifie b  
Fil Contro Bloc an  fla whic indicate whethe t 
includ Syste o Non-Syste file an wha use are i 
t b examined pack th loade director (removin 
entrie no selecte fro th memor buffer) alphabet
ize th director entrie b fil nam an typ o b 
fil typ an name an return  pointe t th firs 
entr an  coun o th numbe o entrie selected


     I man ways SYSLI bring som o th advantage o pro
grammin i  High-Orde Language lik  o Pascal t th 
assembl languag programmer I allow hi t maintai th 
smalle cod siz an greate efficienc whic ca b realize i 
assembl languag programmin an simultaneousl realiz  re
duce life-cycl cos (fro developmen t fieldin t post-
fieldin maintenanc an modification ove assembl languag 
programmin withou  SYSLIB-lik too set.



1.04 How Do I Assemble with SYSLIB?

     Eac exampl i Sectio 2 o thi manua show a assembl 
o th sampl program   frequentl us  comman file whic  
cal M80.SUB t assembl m programs  Thi comman fil take 
onl on parameter th nam o th fil t b assemble WITHOU 
its type (MAC is assumed).  Warning:  The command MUST be:

                        SUB M80 filename

and it MUST NOT be:

                      SUB M80 filename.typ

I i i o th latte form th sourc cod wil b delete 
durin th assembl process  Yo ma wis t remov the

                           ER $1.BAK 

comman i th M80.SU fil t eliminat thi problem   onl d 
this for a space savings.


     My M80.SUB command file is:

;  M80.SUB -- MACRO-80 Assembler and Linker
M80 =$1
SUB /A  PLEASE ABORT IF ERROR(S) EXIST
ERA $1.BAK
ERA $1.COM
L80 /P:100,$1,A:SYSLIB/S,$1/N,/U,/E
ERA $1.REL
;  ASSEMBLY COMPLETE

      ru ZCPR instea o th CP/ 2. CCP an  a alway o 
Driv B doin m developmen work whil m editor an 
assembler (an SYSLIB.REL ar o Driv A:  Not tha thi i 
reflected in M80.SUB, where L80 looks for A:SYSLIB for the scan.



1.05 How Do I Learn to Use SYSLIB Effectively?

     Thi is o course opinion bu  fee tha th bes wa t 
learn how to use SYSLIB would involve the following steps:

          1  Stud th SYSLI manua i a overvie fashion 
familiarizin yoursel wit th function o th subroutine 
available

          2  Stud i som detai th sampl sourc program i 
Sectio 21 jumpin bac t th mai bod o th manua fro tim 
t tim t se wh th routine  selecte i th program wer 
used in the way I used them

          3  Tr codin  coupl o th routine i thi manual 
copying them verbatim and assembling them

          4  Tr makin u  fe simpl problem o you ow an 
use SYSLIB to code them

          5  Appl SYSLI t  significan progra yo wan t 
write

      a  stron advocat o writin program i orde t lear 
ho t program an  fee tha i i mos importan t (1 gai 
a muc familiarit wit th SYSLI routine a yo ca an (2 
t writ program usin thes routines.




1.06 Who May Use SYSLIB?

     SYSLI i hereb release t th publi domain  Anyon wh 
wishe t US i ma d s wit n string attached  Th autho 
assume n responsibilit o liabilit fo th us o SYSLIB  I 
i copyrighte b th author Richar Conn wh ha sol right 
t it  SYSLI an it associate documentatio ma b sol b 
itsel o a a independen par o  packag o program onl 
wit th express writte consen o th author  Th author 
however support th us o SYSLI b commercia softwar devel
opers an place n restrictio o th sal o program whic 
ar BASE o SYSLI an us routine containe withi SYSLI  t 
perfor thei majo functions.



     ɠ hop yo enjo usin SYSLI an fin i t b a usefu  
tool as I do.

                                        Richard Conn

.fo  2 - Directory Manipulation Routines                   Page #

2.0  SYSLIB Directory Manipulation Routines


2.01 Introduction
     Thi se o SYSLI routine concern itsel wit th loadin 
o an acces o  dis director fo th genera purpose o th 
user.  Included in this set of routines are the functions of:

          1.  Preallocation of buffer space for the routines

          2.  Two routines which load all undeleted directory
               entries into a buffer, constantly checking for
               memory overflow as they go
                    DIRLOAD loads the first entry for each file
                         (this is the faster of the two)
                    DIRSLOAD loads the last entry for each file
                         (this routine is required if the
                              user wishes to compute file sizes)

          3.  A routine to determine the amount of free space on
               the disk

          4.  A routine to compute the size of a file in K

          5.  A routine to sort a loaded directory by file name
               and type or by file type and name

          6.  A routine to select (by marking) a set of directory
               entries which match a given ambiguous file spec

          7.  A routine to pack the loaded directory, leaving in
               it only those entries marked by the select routine



2.02 Generalized Routines -- DIRF and DIRFS
     Routine Name: DIRF and DIRFS
     Function
          Thi routin initialize th buffe area load  dis 
directory select  se o file fro th loade director 
specifie b th user' ambiguou fil nam an  passe fla 
(whic indicate i Syste file ar selected Non-syste file 
ar selected al use area ar t b covered an wha 
particula use are i t b covere i al use area ar no 
selected) pack th directory an alphabetize th director b 
fil nam an fil type.
     I DIR i used th processin proceed faste sinc onl 
th firs entr o eac fil i loade int th memor buffer  
Fil sizin informatio i no include i thi load however.
     I DIRF i used th processin i somewha slower bu th 
las entr fo eac fil i loade rathe tha th first  Fil 
sizin informatio i containe i thi entry an䠠 thi 
informatio ca b use b th FSIZ routine.

     Inputs:  HL points to a dynamic buffer which extends from
               after the user's code and buffer areas to the
               end of the TPA
              DE points to the first byte of the FCB used to
               specify the ambiguous file name; only the chars
               in the FN and FT fields are significant, so this
               need not be a true FCB and may be as short as 12
               bytes
              A is the selection flag, structured as follows:
               Bit 7 - If Set, Select Non-System Files
               Bit 6 - If Set, Select System Files
               Bit 5 - If Set, Select All User Areas
               Bits 4-0 - If Bit 5 is Cleared, contains number
                    of User Area to Select

     Outputs:  HL points to the first file entry in the buffer;
                each file entry is 16 bytes long
               BC contains the number of files selected
          A contains an error flag; A=0 and Zero Flag Set
           (Z) indicates TPA overflow error during load of
           directory entries; A<>0 and NZ indicates load OK

     Registers Affected:  HL, BC, PSW

     SYSLIB Routines Called:  DBUFFER, DIRLOAD, DIRSEL, DIRPACK,
                              DIRALPHA

     Special Error Conditions:  As outline for the A register
     above.



2.03 Buffer Allocation Routine -- DBUFFER
     Routine Name: DBUFFER
     Function:
          Thi routin allocate th buffe spac necessar fo 
th se o director function i general  I particular i 
allocate th necessar spac fo th alphabetizatio functio a 
wel a th loade director itself  Thi routin mus b use 
i th DIRALPH routin i t b late use t sor th 
directory thi routin allocate al th spac necessar b 
DIRALPH t sor th routin (pointe space)  I thi routin i 
called i i no necessar t cal th DPARAM routine.

     Inputs:  HL points to the beginning address of a dynamic
          buffer area which extends to under the CCP

     Outputs:  HL points to the first byte at which the directory
           entries are to be loaded
          A=0 and Zero Flag is Set (Z) if the CCP is
           already overrun; else, A<>0 and NZ

     Registers Affected:  HL, PSW

     SYSLIB Routines Called:  DPARAMS

     Special Error Conditions:  As indicated by A reg and Z flag



2.04 Disk Parameter Information Extraction Routine -- DPARAMS
     Routine Name:  DPARAMS
     Function:
     Thi routin extract necessar informatio fro th Dis 
Paramete Bloc (DPB an store i awa i som globa buffer 
use b othe Dis Director Routines  Th informatio extracte 
i no o genera concer b th programmer  AL TH PROGRAMME 
NEEDӠ T KNO I THA THI ROUTIN MUS B CALLE A LEASԠ ONC 
BEFOR TH DIRLOA O DIRSLOA ROUTIN I CALLED  I th DBUFFE 
routin i called the i i no necessar t cal DPARAM 
again.
     Fo th informatio o th reader th followin informatio 
i extracted:
          BLKSHF <-- Block Shift Factor (1 Byte)
          BLKMSK <-- Block Mask (1 Byte)
          EXTENT <-- Extent Mask (1 Byte)
          BLKMAX <-- Max Number of Blocks on Disk (2 Bytes)
          DIRMA <-- Ma Numbe o Di Entrie ( Bytes)
     Thi routin automaticall adjust fo version 1. an 2. 
o CP/ an i compatabl wit bot version o CP/M.

     Inputs:  None

     Outputs:  None (Information Extracted into Buffers)

     Registers Affected:  None

     SYSLIB Routines Called:  None

     Special Error Conditions:  None



2.05 Free Space Computation Routine -- DFREE
     Routine Name: DFREE
     Function:
          Thi routin compute th amoun o fre spac (i  
bytes lef o disk.

     Inputs:  None

     Outputs:  DE = Amount of Free Disk Space in K Bytes

     Registers Affected:  DE

     SYSLIB Routines Called:  DPARAMS

     Special Error Conditions:  None




2.06 File Size Computation Routine -- FSIZE
     Routine Name: FSIZE
     Function:
          Thi routin compute th siz o  fil whos entr 
(whic MUS b loade b DIRSLOAD i pointe t b HL  Thi 
routin wil work bu generall retur incorrec results i th 
entr pointe t wa loade b DIRLOA instead.

     Inputs:  HL points to first byte of file entry

     Outputs:  DE contains the file size in K Bytes

     Registers Affected:  DE

     SYSLIB Routines Called:  DPARAMS

     Special Error Conditions:  None


2.07 Directory Load Routines -- DIRLOAD and DIRSLOAD
     Routine Names: DIRLOAD and DIRSLOAD
     Function:
          DIRLOAĠ an DIRSLOA loa entrie fo al undelete 
file o th currentl logge i dis int th memor buffe 
pointe t b HL  Al entrie ar 1 byte long.
     DIRLOAĠ i faste tha DIRSLOAD  I load jus th firs 
entr o eac fil o disk  DIRLOAD however shoul b use 
onl i fil sizin informatio i no require b th 
application program.
     DIRSLOAĠ load jus th LAS entr o eac fil o disk  
Thi entr contain th necessar fil sizin informatio whic 
ma b use b FSIZ t comput th siz o th loade file.
     I th TP i fille durin DIRLOA o DIRSLOA an ther 
ar stil mor fil entrie t load th loa wil b halte an 
a erro retur wil b mad t th caller  O return i A= 
an th Zer Fla i Se (Z) the  loa erro occurred 
otherwise th loa wa OK.

     Inputs:  HL points to the first byte of the directory buffer
          area; this area extends from after the last buffer
          used by the applications program to the page
          before the CCP.  If alphabetization is to be done,
          the value returned in HL by DBUFFER is a correct
          input for DIRLOAD or DIRSLOAD
         A=0 and Zero Flag is Set (Z) if TPA Overflow;
          A<>0 and NZ if load OK

     Outputs:  BC is the number of files loaded into the buffer

     Registers Affected:  BC

     SYSLIB Routines Called:  None

     Special Error Conditions:  If TPA is filled and load is
     incomplete, A=0 and Zero Flag is Set (Z) as error indic


2.08 Directory Alphabetization Routine -- DIRALPHA
     Routine Name: DIRALPHA
     Function:
          T alphabetiz th file i th director pointe t b 
H̠ b eithe fil nam an typ (STEST.AS goe befor TEST.AAA 
o b fil typ an nam (TEST.AA goe befor STEST.ASM).

     Inputs:  HL points to first directory entry
         BC contains the number of files to sort
          i th sor flag A= mean sor b fil nam an 
     then file type, A<>0 means by file type and name

     Outputs:  None (directory list is sorted)

     Registers Affected:  PSW

     SYSLIB Routines Called:  PRINT

     Special Error Conditions:
     I i possible alth highl unlikel fro al test 
give s far tha DIRALPH ma experienc a interna 
error.  If this happens, the message:
          DIRALPHA -- Pointer Error
wil b printe an th routin wil abor t CP/M  I thi 
happens pleas repor thi proble an b prepare t 
duplicat th exac situatio whic cause thi erro t th 
author, Richard Conn.



2.09 Directory Entry Selection Routine -- DIRSEL
     Routine Name: DIRSEL
     Function:
          DIRSE̠ select al entrie i th director buffe 
whic matc th ambiguou fil nam specifie i th FΠ an F 
field o th FC pointe t b D upo entr t DIRSEL   
selectio fla i als passe t DIRSE i th  register an 
thi fla tell DIRSE whethe o no t includ Non-Syste file 
an Syste file i th selectio an whethe t selec file i 
al use area o i  particula use area.
     DIRSE̠ identifie th selecte fil entrie b settin th 
Mos Significan Bi o th firs byt o eac o thes entrie 
t  i th entr i selected  DIRSE make n othe change t 
th fil entrie i th director buffer.


     Inputs:  HL points to the directory buffer
         DŠ point t th FC containin th ambiguou F 
          and FT fields; only the first 12 bytes are needed
         BC contains the number of files in the directory
         A contains a selection flag, organized as follows:
          Bit 7 - Select Non-System Files
          Bit 6 - Select System Files
          Bit 5 - Select Files in All User Areas
          Bits 4-0 - If Bit 5 is 0, indicates number of
               User Area to select files from

     Outputs:  None (MSBs of selected entries are set)

     Registers Affected:  None

     SYSLIB Routines Called:  None

     Special Error Conditions:  None



2.10 Directory Pack Routine -- DIRPACK
     Routine Name:  DIRPACK
     Function:
          DIRPACˠ restructure th director buffe t contai 
onl thos entrie marke b DIRSEL  I thi way thos entrie 
NOԠ marke b DIRSE ar discarde fro th buffe (actually 
jus take ou o consideration bu th content o th buffe 
afte th las selecte entr i no guarantee t contai 
anythin significant).
     Th Mos Significan Bi o th firs byt o al entrie 
remainin i th director buffe i rese t  a  sid effec 
o DIRPACK.

     Inputs:  HL points to the directory buffer
         BC contains the number of files in the buffer

     Outputs:  BC contains the number of files (those selected by
           DIRSEL) remaining in the directory buffer

     Registers Affected:  BC

     SYSLIB Routines Called:  None

     Special Error Conditions:  None


2.11 Negative Directory Pack Routine
     Routine Name:  DIRNPACK
     Function:
          DIRNPACˠ restructure th director buffe t contai 
onl thos entrie NO marke b DIRSEL  I thi way thos 
entrie marke b DIRSE ar discarde fro th buffe (actually 
jus take ou o consideration bu th content o th buffe 
afte th las selecte entr i no guarantee t contai 
anythin significant).
     Th Mos Significan Bi o th firs byt o al entrie 
remainin i th director buffe i rese t  a  sid effec 
o DIRNPACK.

     Inputs:  HL points to the directory buffer
         BC contains the number of files in the buffer

     Outputs:  BC contains the number of files (those NOT selected
           by DIRSEL) remaining in the directory buffer

     Registers Affected:  BC

     SYSLIB Routines Called:  DIRPACK

     Special Error Conditions:  None

.fo  3 - Numeric String Evaluation Routines                Page #

3.0  Numeric String Evaluation Routines

3.01 Evaluation of String at All Bases -- EVAL
     Routine Name:  EVAL
     Function
          Thi routin convert th characte strin pointe t 
b H̠ int th 16-bi binar numbe represente b it  EVA 
perform th conversio unti  non-hexadecima characte i 
encountered a whic tim i look a th las characte an th 
previou characte t determin i th strin i representin  
binary octal decimal o hexadecima number  Inpu strin 
character ma b upper- o lower-case  Vali format fo th 
inpu strin ar --
          bbbbbbbbbbbbbbbbB -- b=0 or b=1; Binary string
          ttttt or tttttD -- 0 <= t <= 9; Decimal string
          hhhhH or hhhhX -- 0 <= h <= F; Hexadecimal string
          oooooooO or oooooooQ -- 0 <= o <= 7; Octal string

     Inputs:  HL points to the first byte of the string to convert
              String is loaded in a buffer

     Outputs:  HL points to next character after converted string
               DE contains 16-bit value
               A = E
               CARR٠ Fla Se mean a erro wa encountere i 
strin format

     Registers Affected:  PSW, DE, HL

     SYSLIB Routines Called:  CAPS, EVAL16, EVAL10, EVAL8, EVAL2

     Specia Erro Conditions
          CARR٠ Fla Se indicate tha a erro wa encountere 
i th evaluatio o th string i so H̠ point t th 
offendin character


3.02 Evaluation of String in Base 16 -- EVAL16
     Routine Name:  EVAL16
     Function
          EVAL1 convert th strin o ASCIɠ hexadecima 
character pointe t b H̠ int  16-bi binar value  
Conversio progresse unti a invali hexadecima digi (0-9 A-
F i encountered.

     Inputs:  HL points to the first byte of the string to convert
              String is loaded in a buffer

     Outputs:  HL points to the offending character
               DE contains the 16-bit value
               A = E

     Registers Affected:  PSW, DE, HL

     SYSLIB Routines Called:  CAPS

     Special Error Conditions:  -None-


3.03 Evaluation of String in Base 10 -- EVAL10
     Routine Name:  EVAL10
     Function
          EVAL1 convert th strin o ASCI decima character 
pointe t b H̠ int  16-bi binar value  Conversio 
progresse unti a invali decima digi (0-9 i encountered.

     Inputs:  HL points to the first byte of the string to convert
              String is loaded in a buffer

     Outputs:  HL points to the offending character
               DE contains the 16-bit value
               A = E

     Registers Affected:  PSW, DE, HL

     SYSLIB Routines Called:  -None-

     Special Error Conditions:  -None-



3.04 Evaluation of String in Base 8 -- EVAL8
     Routine Name:  EVAL8
     Function
          EVAL convert th strin o ASCIɠ octa character 
pointe t b H̠ int  16-bi binar value  Conversio 
progresse unti a invali octa digi (0-7 i encountered.

     Inputs:  HL points to the first byte of the string to convert
              String is loaded in a buffer

     Outputs:  HL points to the offending character
               DE contains the 16-bit value
               A = E

     Registers Affected:  PSW, DE, HL

     SYSLIB Routines Called:  -None-

     Special Error Conditions:  -None-


3.05 Evaluation of String in Base 2 -- EVAL2
     Routine Name:  EVAL2
     Function
          EVAL convert th strin o ASCI binar character 
pointe t b H̠ int  16-bi binar value  Conversio 
progresse unti a invali binar digi (0-1 i encountered.

     Inputs:  HL points to the first byte of the string to convert
              String is loaded in a buffer

     Outputs:  HL points to the offending character
               DE contains the 16-bit value
               A = E

     Registers Affected:  PSW, DE, HL

     SYSLIB Routines Called:  -None-

     Special Error Conditions:  -None-

.fo  4 - Byte-Oriented File Input/Output Routines          Page #

4.0 Byte-Oriented File Input/Output Routines

4.01 Introduction to Byte-Oriented File Input/Output Routines

     Th followin documentatio cover th serie o byte-
oriente fil input/outpu routine i SYSLIB  Thes routine 
allo th use t sequentiall rea fro (GET an writ t (PUT 
 fil o  byte-for-byt basis  Hence thes routine provid 
a exceptionall simpl metho fo handlin inpu fro an outpu 
t  file.

      typica progra whic employ thes routine mus ope th 
require file befor doin an processing mus the perfor th 
processin o th opene files an mus the clos th file 
whe th processin i complet (closin th file i optiona 
fo inpu file an mandator fo outpu files).

     SYSLI provide fou set o routine fo byte-oriente fil 
inpu an output  Thes routine ar --

Input Open  Output Open  GET    PUT   Input Close  Output Close
----------  -----------  ---    --   -----------  ------------
 FI0$OPEN    FO0$OPEN   F0$GET F0$PUT  FI0$CLOSE    FO0$CLOSE
 FI1$OPEN    FO1$OPEN   F1$GET F1$PUT  FI1$CLOSE    FO1$CLOSE
 FI2$OPEN    FO2$OPEN   F2$GET F2$PUT  FI2$CLOSE    FO2$CLOSE
 FI3$OPEN    FO3$OPEN   F3$GET F3$PUT  FI3$CLOSE    FO3$CLOSE

     Thi syste allow th use t hav u t  file ope 
simultaneousl -- fou ar ope fo inpu usin GE an fou ar 
ope fo outpu usin PUT  Fo example th followin i  
sampl cod sectio usin thes routine fo tw files:

          EXT  FI0$OPEN   ; DECLARE LIBRARY REFERENCES
          EXT  FO0$OPEN
          EXT  FI0$CLOSE
          EXT  FO0$CLOSE
          EXT  F0$GET
          EXT  F0$PUT
          ...
          LXI  D,FCBI    ; PT TO FCB OF INPUT FILE
          CALL FI0$OPEN
          LXI  D,FCBO    ; PT TO FCB OF OUTPUT FILE
          CALL FO0$OPEN
          ...
          [body containing CALL F0$GET and CALL F0$PUT where required]
          ...
          CALL FI0$CLOSE  ; CLOSE FILE
          CALL FO0$CLOSE
          ...
          END


     Not tha onl th routine t b use ar reference i th 
EX statements  I yo d no nee  particula routine d no 
referenc it  No referencin a unneede routin generall 
save th overhea memor spac o loadin i fro th library.

     Eac se o INPU OPEN INPU CLOSE OUTPUԠ OPEN OUTPU 
CLOSE GET an PU routine i containe i on librar module 
s referencin an o thes routine cause th entir modul t 
b loaded an al th routine ar accessabl t th use 
(provide the ar mentione i th externa definitions withou 
an additiona memor overhead  Specifically FI0$OPEN 
FI0$CLOSE FO0$OPEN FO0$CLOSE F0$GET an F0$PU ar containe 
i on module an referenc t an o thes routine load th 
entir module th sam i tru fo th othe set o routines.

     Th CLOS routin fo outpu (FOn$CLOSE i ALWAY required 
i fill th res o th curren bloc wit Ctrl- followe b 
<NULL byte an properl close file  Th CLOSŠ routin fo 
inpu (FIn$CLOSE i require ONL I yo ar goin t late ope 
anothe fil fo inpu usin th correspondin OPEΠ routin 
(FIn$OPEN)  FIn$CLOSŠ onl serve t rese th OPE fla (use 
t GE t ascertai tha th fil ha bee properl opened).



4.02 Byte-Oriented Input and Output File Open
     Routine Names:  FI0$OPEN, FI1$OPEN, FI2$OPEN, FI3$OPEN
     Function
          Ope th fil whos FC i pointe t b D fo inpu 
(us wit F$GET).

     Inputs:  DE = ptr to FCB of file to open

     Outputs:  Z Flag is Error Indicator, A is Error Code

     Registers Affected:  PSW

     SYSLIB Routines Called:  Internal

     Special Error Conditions:  See Section on Error Codes



     Routine Names:  FO0$OPEN, FO1$OPEN, FO2$OPEN, FO3$OPEN
     Function
          Ope th fil whos FC i pointe t b D fo outpu 
(us wit F$PUT).

     Inputs:  DE = ptr to FCB of file to open

     Outputs:  Z Flag is Error Indicator, A is Error Code

     Registers Affected:  PSW

     SYSLIB Routines Called:  Internal

     Special Error Conditions:  See Section on Error Codes



4.03 Byte-Oriented Input and Output File Close
     Routine Names:  FI0$CLOSE, FI1$CLOSE, FI2$CLOSE, FI3$CLOSE
     Function
          Clos th fil previousl opene b th correspondin 
FI$OPEΠ routine  Us o thes routine i optiona i th 
anothe fil wil no b opene late i th progra b th 
correspondin FI$OPE routine.

     Inputs:  -None-

     Outputs:  Z Flag is Error Indicator, A is Error Code

     Registers Affected:  PSW

     SYSLIB Routines Called:  Internal

     Specia Erro Conditions:  See Section on Error Codes



     Routine Names:  FO0$CLOSE, FO1$CLOSE, FO2$CLOSE, FO3$CLOSE
     Function
          Clos th fil previousl opene b th correspondin 
FO$OPE routine  Us o thes routine i MANDATOR afte outpu 
t th fil (usin th correspondin F$PU routine i complete.

     Inputs:  -None-

     Outputs:  Z Flag is Error Indicator, A is Error Code

     Registers Affected:  -None-

     SYSLIB Routines Called:  Internal

     Specia Erro Conditions:  See Section on Error Codes



4.04 Byte-Oriented Input and Output
     Routine Names:  F0$GET, F1$GET, F2$GET, F3$GET
     Function
          Ge th nex byt i sequenc fro th fil previousl 
opene b th correspondin FI$OPE routine  Byt i returne i 
Registe A.

     Inputs:  -None-

     Outputs:  A = Next byte from file if no error
               If Error, NZ and A = Error Code

     Registers Affected:  PSW

     SYSLIB Routines Called:  Internal

     Specia Erro Conditions:  See Section on Error Codes



     Routine Names:  F0$PUT, F1$PUT, F2$PUT, F3$PUT
     Function
          Pu th byt i Registe  ont th en o th fil 
previousl opene b th correspondin FO$OPE routine.

     Inputs:  A = Byte to PUT

     Outputs:  Z Flag is Error Indicator, A is Error Code

     Registers Affected:  PSW

     SYSLIB Routines Called:  Internal

     Specia Erro Conditions  See Section on Error Codes



4.05 Error Return Codes

     Fo eac o th routine i thi se o byte-oriente fil 
I/ routines th Zer Fla an th  Registe pla  ke rol i 
indicating the error conditions of the routines.

     I th Zer Fla i Se (Z afte  routin ha bee 
executed the thi indicate tha n erro ha occurred  Th  
Registe i eithe unaffecte (i mos cases o contain  
returned value (if so indicated, as in Fn$GET routines).

     I th Zer Fla i Clea (NZ afte  routin ha bee 
executed the thi indicate tha a erro ha occurred  Th  
Registe no contain th Erro Code  Th followin tabl 
summarize th Erro Code whic ma b returne i th  
Register.


     The following display summarizes the Error Codes.


                     Summary of Error Codes
           Returned by Byte-Oriented File I/O Routines

          Code Meaning
          ---- -------

            1  GET or PUT attempted on an unopened file
            2  Disk Full (Ran out of space)
            3  Input File Not Found
            4  Attempt to Read Past EOF
            5  Directory Full
            6  Error in Closing a File
            7  Attempt to Open a File which is already Open


.fo  5 - CP/M File Input/Output Routines                   Page #

5.0 CP/M File Input/Output Routines

5.01 Introduction

     Th followin routine ar general-purpos fil I/ routine 
whic interfac t CP/ throug th Entr Poin a locatio 5  
The preserv BC DE an HL an the retur wit th standar 
CP/ erro code fo th correspondin routines.

     Specifically, these routines are --

          F$OPEN    Open a file
          F$MOPEN   Open/Create a file
          F$CLOSE   Close a file
          F$MAKE    Create a file
          F$DELETE  Delete a file
          F$RENAME  Rename a file
          F$EXIST   Test of existance of a file
          F$READ    Read a block (128 bytes) from a file
          F$WRITE   Write a block (128 bytes) to a file



5.02 Open a File
     Routine Name:  F$OPEN
     Function
          Ope th fil specifie b th FC pointe t b DE  
I fil no found F$OPE return wit a erro cod i  (0FFH 
an Zer Fla Clea (NZ).

     Inputs:  DE = pointer to FCB

     Outputs:  A = Error Code and PSW Flags Set (Zero Flag)
                   0    --> No Error
                   0FFH --> File not opened

     Registers Affected:  PSW

     SYSLIB Routines Called:  BDOS, CAPS, CIN, COUT, CRLF, PRINT

     Special Error Conditions:  -None-




     Routine Name:  F$MOPEN
     Function
          Ope th fil specifie b th FC pointe t b DE  
I fil i no found F$MOPE trie t creat one  I return 
th erro cod o 0FF i  i ther wa no enoug roo i th 
dis director t creat th director entry.

     Inputs:  DE = pointer to FCB

     Outputs:  A = Error Code and PSW Flags (Zero Flag) Set
                   0    --> No Error
                   0FFH --> File not opened

     Registers Affected:  PSW

     SYSLIB Routines Called:  BDOS, CAPS, CIN, COUT, CRLF, PRINT

     Special Error Conditions:  -None-



5.03 Close a File
     Routine Name:  F$CLOSE
     Function:
          Close the file whose FCB is pointed to by DE.

     Inputs:  DE = pointer to FCB

     Outputs:  A = Error Code
                   0    --> No Error
                   0FFH --> Error in closing file

     Registers Affected:  PSW

     SYSLIB Routines Called:  BDOS

     Special Error Conditions:  -None-




5.04 Create a File
     Routine Name:  F$MAKE
     Function:
          Create (Make) the file whose FCB is pointed to by DE.

     Inputs:  DE = pointer to FCB

     Outputs:  A = Error Code
                   0FFH --> No directory space available
                   Not 0FFH --> No Error; Value is byte address in
                                TBUFF (80H-0FFH) of directory entry
                                allocated to the FCB

     Registers Affected:  PSW

     SYSLIB Routines Called:  BDOS, F$DELETE

     Special Error Conditions:  -None-



5.05 Delete a File
     Routine Name:  F$DELETE
     Function
          Delet th fil whos FC i pointe t b DE  I fil 
doe no exist nothin happen (n erro messag o cod i 
given).

     Inputs:  DE = pointer to FCB

     Outputs:  -None-

     Registers Affected:  PSW

     SYSLIB Routines Called:  BDOS

     Special Error Conditions:  -None-



5.06 Rename a File
     Routine Name:  F$RENAME
     Function
          F$RENAMŠ ma b use t renam  file  O entry D 
pt t th firs twelv byte o th file' FC an H pt t th 
firs twelv byte o th FC fo th ne fil (tha is onl th 
F an F field ar significant s th res o a FC nee no 
b presen fo thi functio t work)  F$RENAMŠ contain a 
interna FC whic i structure fro th tw entrie t properl 
rename the file.

     Inputs:  HL pts to 1st 12 bytes of new FCB
              DE pts to 1st 12 bytes of old FCB

     Outputs:  Zero Flag Set (Z) means error (file not found)

     Registers Affected:  PSW

     SYSLIB Routines Called: BDOS, FILLB, MOVEB

     Specia Erro Conditions  Fil No Foun error indicate 
by Z flag



5.07 Test for the Existance of a File
     Routine Name:  F$EXIST
     Function
          F$EXIS test fo th presenc o th fil whos FC i 
pte t b D i th curren disk/use area  I thi fil doe 
no exis i thi area F$EXIS return wit th Zer Fla Se 
(Z); if this file does exist, F$EXIST returns with NZ.

     Inputs:  DE pts to FCB of file to test for

     Outputs:  Zero Flag Set (Z) means file not found; NZ means
                    file found

     Registers Affected:  PSW

     SYSLIB Routines Called:  BDOS

     Specia Erro Conditions  None




5.08 Read a Block from a File
     Routine Name:  F$READ
     Function
          Rea nex bloc (12 bytes fro th opene fil whos 
FC i pointe t b D int TBUF (buffe a 80 - 0FFH).

     Inputs:  DE = pointer to FCB

     Outputs:  A = Error Code
                   0 --> No Error
                   1 --> Read past end of file
                   2 --> Reading unwritten data in random access

     Registers Affected:  PSW

     SYSLIB Routines Called:  BDOS

     Special Error Conditions:  -None-



5.09 Write a Block to a File
     Routine Name:  F$WRITE
     Function
          Writ nex bloc (12 bytes fro TBUF (buffe a 80 
t 0FFH t th opene fil whos FC i pointe t b DE.

     Inputs:  DE = pointer to FCB

     Outputs:  A = Error Code
                   0    --> No Error
                   1    --> Error in extending file
                   2    --> End of disk data
                   0FFH --> No more directory space

     Registers Affected:  PSW

     SYSLIB Routines Called:  BDOS

     Special Error Conditions:  -None-

.fo  6 - File Name String Parser and FCB Init              Page #

6.0 File Name String Parser and FCB Init

     Routine Name: FNAME
     Function:
          FNAMŠ i  fil nam scanner  Pointin t th firs 
characte o  fil nam specificatio o th form:

          du:filename.typ

wher an par o th specificatio i optional thi routin 
fill i a FC wit zeroe (3 bytes) properl initialize th 
F (Fil Name fiel i 'filename i presen an F (Fil Type 
fiel i 'typ i present an return th numbe o th selecte 
dis (i th rang fro  fo  t 1 fo P i 'd i presen 
an th numbe o th selecte use (i th rang fro  t 3 
an th questio mar '? character i 'u i present  I 'd 
i no present 0FF i returne fo i t indicat curren disk 
an i 'u i no present 0FF i returne fo i t indicat 
curren user.

     Th strin pointe t b H i no  conventiona strin i 
th sens o th res o th SYSLI routines  Thi strin i 
terminate b an o th followin delims a oppose b simpl 
alway bein terminate b  binar zero  Th delimite lis is:

          <NULL or Binary 0>       <SP or Space>
          =    _    ;    ,    <    >

     Th followin ar vali examples:
          test.txt   <-- FN=TEXT  FT=TXT, B reg = 0FFH,
                         C reg = 0FFH
          a:t        <-- FN=T  FT=<SP>, B reg = 1,
                         C reg = 0FFH
          5:t        <-- FN=T  FT=<SP>, B reg = 0FFH,
                         C reg = 5
          c10:x.y    <-- FN=X  FT=Y, B reg = 3,
                         C reg = 10


     Inputs:  HL points to the first byte of the target string
               (which ends in a delimiter)
         DE pts to the first byte of a 36-byte long FCB

     Outputs:  B=Disk Number (1 for A to 16 for P, or 0FFH if
               no disk specified)
          C=User Number (0 to 31 or '?' for all users, or
               0FFH if no user specified)
          HL points to the character which ended the scan
          A = 0 and Zero Flag Set (Z) if invalid Disk or User
               Specified; A = 0FFH and NZ if no error
     Registers Affected: PSW, BC, HL
     SYSLIB Routines Called:  CAPS
     Special Error Conditions:  None


     Routine Name:  INITFCB
     Function
     INITFC  simpl clear al o th field o  36-byt 
FC  t zer excep fo th F an F (Fil Nam an Fil 
Type fields whic i leave untouched.

     Inputs:  DE = pointer to FCB buffer

     Outputs:  None

     Registers Affected:  None

     SYSLIB Routines Called:  FILLB

     Special Error Conditions:  None

.fo  7 - Input Line Editors                                Page #

7.0 Input Line Editors

     A Inpu Lin Edito i use t accep  lin o tex fro 
th user allowin hi t issu command lik backspac an Ctrl-
ؠ (eras al o lin type s far t edi hi tex a h i 
inputtin it  Onc th tex ha bee entered th Inpu Lin 
Edito return t th callin progra wit th user' tex store 
in a buffer.  This text is terminated by a binary 0.

     Tw o th Inpu Lin Editor i SYSLI us th CP/ BDO t 
provid th lin edito function  The mainl serv t preserv 
th register durin th functio cal an t stor堠 th 
terminatin zer a th en o th text  The occup les spac 
than the third Input Line Editor, INLINE.

     Th thir Inpu Lin Editor INLINE i use whe securit 
i important  Unlik th othe two whe typin  Ctrl-à t 
INLINE th Inpu Lin Edito (an callin program i no 
aborte an contro returne t CP/M  Instead th Ctrl- cha 
i simpl store i th user' line  Also unlik th othe two 
INLINŠ ca b instructe t ech o no ech th堠 inpu 
characters  Thi featur i usefu fo program whic wan t 
inpu  password  INLINŠ ca b instructe no t ech th 
password bu i wil stil provid th lin editin function 
for the user so that he can correct mistakes if he makes them.


     Routine Name:  BBLINE
     Function:
          BBLIN provide  ver convenien interfac t th BDO 
fo inpu lin edito functions  I contain it ow interna 
buffe fo storag o th inpu lin (20 byte allocated) an 
i return  pointe t th firs byt o th lin upo return  
Th lin store i thi buffe i terminate b  binar zer 
(0).

     T us BBLINE th use nee onl cal it wit  
capitalizatio fla store i th  Register  I   0 BBLIN 
doe no capitaliz th inpu lin characters i  < 0 BBLIN 
capitalize th inpu lin character befor returnin t th 
caller.

     N erro code ar returne b BBLINE  O return H point 
t th firs byt o th inpu lin an  contain  coun o th 
numbe o character i tha lin (no countin th endin zero).


     Inputs:  A=0 to Not Capitalize Line, A<>0 to Capitalize Line

     Outputs:  HL pts to first char in the line
               A is number of characters in the line (not
                    counting the ending zero)

     Registers Affected:  PSW, HL

     SYSLIB Routines Called:  CAPS

     Special Error Conditions:  None



     Routine Name:  BLINE
     Function:
          BLIN provide  ver convenien interfac t th BDO 
fo inpu lin edito functions  I perform th sam typ o 
functio a BBLINE bu i doe no contai it ow interna 
buffer  Th use i expecte t provid suc  buffer whic i 
structure a follows:

               SIZE:     DB   <Size of Buffer>
               CCNT:     DS   1
               LINE:     DS   <Size of Buffer + 1>
 
BLIN return  pointe t th firs byt o th lin (LINE upo 
return  Th lin store i thi buffe i terminate b  binar 
zer (0).

     T us BLINE th use nee onl cal it wit  pointe t 
th user' buffe i H an  capitalizatio fla store i th  
Register  I   0 BLIN doe no capitaliz th inpu lin 
characters i  < 0 BLINŠ capitalize th inpu lin 
character befor returnin t th caller.

     N erro code ar returne b BLINE  O return H point 
t th firs byt o th inpu lin an  contain  coun o th 
numbe o character i tha line (not counting the ending zero).

     Inputs:  A=0 to Not Capitalize Line, A<>0 to Capitalize Line
              HL pts to first byte (SIZE) of user-supplied buffer

     Outputs:  HL pts to first char in the line
               A is number of characters in the line (not
                    counting the ending zero)

     Registers Affected:  PSW, HL

     SYSLIB Routines Called:  CAPS

     Special Error Conditions:  None



     Routine Name:  INLINE
     Function
          INLINŠ allow th use t inpu  lin o tex fro 
CON int th buffe pointe t b HL  Th use i allowe t 
edi th tex a h type it an INLINŠ respond t th 
followin edito commands:

   Key Command    Function
     <BS>           Delete previous character and back up cursor
     <DEL>          Delete previous character and echo it
     <CR>           Input complete -- return to calling program
     <LF>           Skip down to next physical line and insert a
                      <CR> <LF> into buffer
     <TAB>          Tabulate to next tab stop (every 8)
     Ctrl-U,        Erase current line (clear buffer) and restart
       Ctrl-X         input
     Ctrl-R         Retype current line
     Ctrl-         Ski dow t nex physica line inser 
                      nothing into buffer

     O exit th buffe contain th tex entere followe b  
<NULL (binar 0) th <CR type t en th inpu i NO place 
i th buffer.


    Inputs:  HL = pointer to input line buffer
              A = Echo Flag (A=0 Means Don't Echo Input)
     Outputs:  -None- (Input line buffer contains text typed by user)
     Registers Affected:  -None-
     SYSLIB Routines Called:  CCOUT, CIN, COUT, CRLF

     Specia Erro Conditions
          <BEL (Bee a CON: i outpu i attemp i mad t 
delet characte (<BS o <DEL> befor beginnin o line  N 
limi o erro checkin i don o th siz o th inpu lin 
buffe (buffe overflo i possible s i i recommende tha 
buffe i mad arbitraril large)  Has mar (# i printe i 
respons t Ctrl-R Ctrl-U an Ctrl-X.

     Note  INLINŠ offer tw feature no foun i BLINŠ an 
BBLINE  First i canno b aborte b  Ctrl-C thi i good 
sinc i ca b use i "secure program withou fea o th 
use breakin ou o th program  Second i ca b mad t ech 
o no ech th input thi provide som protectio fo 
inputtin sensitiv information lik  password.

     INLINŠ essentiall provide al o th conventiona inpu 
lin edito functions  I i somewha mor flexibl tha BLIN 
an BBLINE bu th tradeof i tha INLIN take u mor spac 
tha eithe BLIN o BBLINE  I securit i no required i i 
recommende tha th programme emplo BLIN o BBLIN instea o 
INLINE.


.fo  8 - String Output Routines                            Page #

8.0 String Output Routines -- PRINT, LPRINT, PSTR, LPSTR

     Routine Names:  PRINT, LPRINT
     Function
          Prin strin pointe t b th retur addres o CON 
(PRINT o LST (LPRINT)  Strin i terminate b  binar 0  
Contro i returne t byt followin string.

     Inputs:  Return Address = pointer to string to be printed

     Outputs:  HL points to byte after string
               (string is printed on CON: or LST:)

     Registers Affected:  HL

     SYSLIB Routines Called:  PSTR (for PRINT); LSTR (for LPRINT)

     Specia Erro Conditions:
          Th strin MUS b terminate b  binar 0!!!



     Routine Names:  PSTR, LPSTR
     Function
          Prin strin pointe t b H o CON (PSTR o LST 
(LPSTR)  Strin i terminate b  binar 0.

     Inputs:  HL = pointer to string to be printed

     Outputs:  -None- (string is printed on CON: or LST:)

     Registers Affected:  -None-

     SYSLI  Routine Called  CCOUT COU (fo PSTR)
                               LCOUT LOU (fo LPSTR)

     Specia Erro Conditions:
          Th strin MUS b terminate b  binar 0!!!

.fo  9 - Numeric Output Routines                           Page #

9.0 Numeric Output Routines

9.01 Output HL as 4 Hexadecimal Characters

     Routine Names:  PHL4HC, LHL4HC
     Function
          Prin H̠ a fou (4 hexadecima character o CON 
(PHL4HC o LST (LHL4HC).

     Inputs:  HL = value to be printed

     Outputs:  -None- (Value is printed)

     Registers Affected:  -None-

     SYSLIB Routines Called:  PA2HC (for PHL4HC);
                              LA2HC (for LHL4HC)

     Special Error Conditions:  -None-



     Routine Name:  MHL4HC
     Function
          Stor H a fou (4 hexadecima character i th 4-
byt memor buffe pointe t b DE  O return D point t th 
byt followin thi buffer.

     Inputs:  HL = value to be converted and stored
              DE points to 4-byte buffer

     Outputs:  DE points to byte after buffer

     Registers Affected:  DE

     SYSLIB Routines Called:  MA2HC

     Special Error Conditions:  -None-



9.02 Output HL as 5 Decimal Character

     Routine Names:  PHL5DC, LHL5DC
     Function
          Prin H̠ a fiv (5 decima character o CON 
(PHL5DC o LST (LHL5DC).

     Inputs:  HL = value to be printed

     Outputs:  -None- (Value is printed)

     Registers Affected:  -None-

     SYSLIB Routines Called:  POUT (for PHL5DC); LOUT (for LHL5DC)

     Special Error Conditions:  -None-



     Routine Name:  MHL5DC
     Function
          Stor H a fiv (5 decima character i memor i 
th 5-byt buffe pointe t b DE  O return D point t th 
byt afte thi buffer.

     Inputs:  HL = value to be converted and stored
              DE points to a 5-byte buffer

     Outputs:  DE points to the byte following the buffer

     Registers Affected:  DE

     SYSLIB Routines Called:  -None-

     Special Error Conditions:  -None-



9.03 Output HL as Up to 5 Decimal Character with Leading Spaces

     Routine Names:  PHLDC, LHLDC
     Function
          Prin H̠ a u t fiv (5 decima character wit 
leadin space (<SP> o CON (PHLDC o LST (LHLDC).

     Inputs:  HL = value to be printed

     Outputs:  -None- (Value is printed)

     Registers Affected:  -None-

     SYSLIB Routines Called:  POUT (for PHLDC); LOUT (for LHLDC)

     Special Error Conditions:  -None-

     Routine Name:  MHLDC
     Function
          Stor H̠ a u t fiv (5 decima character wit 
leadin space i th 5-byt memor buffe pointe t b DE.

     Inputs:  HL = value to be converted and printed
              DE points to the 5-byte buffer

     Outputs:  DE points to the byte after the buffer

     Registers Affected:  DE

     SYSLIB Routines Called:  -None-

     Special Error Conditions:  -None-


9.04 Output A as 2 Hexadecimal Characters

     Routine Names:  PA2HC, LA2HC
     Function
          Prin  a tw (2 hexadecima character o CON 
(PA2HC o LST (LA2HC).

     Inputs:  A = value to be printed

     Outputs:  -None- (Value is printed)

     Registers Affected:  -None-

     SYSLI Routine Called  E (fo both) POU (fo PA2HC) 
LOU (fo LA2HC)

     Special Error Conditions:  -None-



     Routine Name:  MA2HC
     Function
          Stor  a tw (2 hexadecima character i th 2-byt 
memor buffe pointe t b DE  O return DE point t byt 
afte buffer.

     Inputs:  A = value to be converted and stored
              DE points to 2-byte buffer

     Outputs:  DE points to byte after this buffer

     Registers Affected:  DE

     SYSLIB Routines Called:  EN

     Special Error Conditions:  -None-


9.05 Output A as 3 Decimal Characters

     Routine Names:  PA3DC, LA3DC
     Function
          Prin  a thre (3 decima character o CON (PA3DC 
o LST (LA3DC).

     Inputs:  A = value to be printed

     Outputs:  -None- (Value is printed)

     Registers Affected:  -None-

     SYSLIB Routines Called:  POUT (for PA3DC); LOUT (for LA3DC)

     Special Error Conditions:  -None-



     Routine Name:  MA3DC
     Function
          Stor  a thre (3 decima character i th 3-byt 
memor buffe pointe t b DE  O return DE point t th byt 
afte th buffer.

     Inputs:  A = value to be converted and stored
              DE points to the 3-byte buffer

     Outputs:  DE points to the byte after the buffer

     Registers Affected:  DE

     SYSLIB Routines Called:  -None-

     Special Error Conditions:  -None-


9.06 Output A as Up to 3 Decimal Characters with Leading Spaces

     Routine Names:  PADC, LADC
     Function
          Prin  a u t thre (3 decima character wit 
leadin space (<SP> o CON (PADC o LST (LADC).

     Inputs:  A = value to be printed

     Outputs:  -None- (Value is printed)

     Registers Affected:  -None-

     SYSLIB Routines Called:  POUT (for PADC); LOUT (for LADC)

     Special Error Conditions:  -None-


     Routine Name:  MADC
     Function
          Stor  a u t thre (3 decima character wit 
leadin space i th 3-byt memor buffe pointe t b DE  O 
return DE point t th byt afte th buffer.

     Inputs:  A = value to be converted and stored
              DE points to the 3-byte memory buffer

     Outputs:  DE points to the byte after the buffer

     Registers Affected:  DE

     SYSLIB Routines Called:  -None-

     Special Error Conditions:  -None-

.fo 10 - String and Value Comparison Routines              Page #

10.0 String and Value Comparision Routines

     Routine Name:  COMPHD
     Function
          Compar H t DE  O return Zer Fla Se = HL=DE 
Carr Fla Se = HL<DE.

     Inputs:  HL, DE -- Values to compare

     Outputs:  Zero and Carry Flags

     Registers Affected:  PSW

     SYSLIB Routines Called:  -None-

     Special Error Conditions:  -None-



     Routine Names:  COMPB, COMPBC
     Function
          Vecto Compar Routines  Compar th vecto pointe t 
b H wit tha pointe t b D (Vector ar o equa length)  
Vector ar  byte lon fo COMP an B byte lon fo COMPBC  
O exit Zer Fla Se indicate tha vector ar identical 
Carr Fla Se indicate tha th vecto pointe t b H i les 
tha th vecto pointe t b DE.

     Inputs:  HL, DE -- Pointers to vectors to compare
              B (for COMPB), BC (for COMPBC) -- number of bytes
               in vectors

     Outputs:  Zero and Carry Flags

     Registers Affected:  PSW

     SYSLIB Routines Called:  -None-

     Special Error Conditions:  -None-



     Routine Name:  SCANNER
     Function
          SCANNE scan th vecto o byte pointe t b H̠ fo 
th vecto o byte pointe t b DE  Th HL-byt vecto i  
byte lon an th DE-byt vecto i  byte long  O return i 
found H point t th beginnin locatio withi th origina H 
vecto o th locate vecto an th Zer Fla i Set i no 
found Zer Fla i no se an H i no affecte (point t th 
beginnin o th origina HL-byt vector).


     Inputs:  HL = Pointer to vector to be scanned
              DE = Pointer to vector to scan for
              B = Number of bytes in HL-vector
              C = Number of bytes in DE-vector

     Outputs:  If found, Zero Set and HL pts to located vector
               If not found, Zero Reset and HL unaffected

     Registers Affected:  PSW, HL

     SYSLIB Routines Called:  -None-

     Specia Erro Conditions  Automati succes i vecto 
searche fo i null.



     Routine Name:  INSTR
     Function
          INSTRINǠ Function  Sca th strin pointe t b H 
fo th strin pointe t b DE   strin i  vecto o byte 
terminate b  binar 0.

          O return i found Zer Fla i Se an H point t 
1s byt o substrin withi scanne string i no found Zer 
Fla i no se an H i no affected.


     Inputs:  HL = Pointer to string to be scanned
              DE = Pointer to string to scan for

     Outputs:  If found, Zero Set and HL pts to located substring
               If not found, Zero Reset and HL unaffected

     Registers Affected:  PSW, HL

     SYSLIB Routines Called:  -None-

     Specia Erro Conditions:
          Automati succes i strin searche fo i null.
.fo 11 - Character Input/Output Routines                   Page #

11.0 Character Input/Output Routines

11.01 <CR> <LF> Output

     Routine Names:  CRLF, LCRLF
     Function:
          Print <CR> and <LF> on CON: (CRLF) or LST: (LCRLF).

     Inputs:  -None-

     Outputs:  -None- (<CR> <LF> is printed)

     Registers Affected:  -None-

     SYSLIB Routines Called:  POUT (for CRLF); LOUT (for LCRLF)

     Special Error Conditions:  -None-



11.02 Conditional Input

     Routine Name:  CONDIN
     Function
          Inpu  characte fro CON i on i available 
otherwise retur  fla statin tha  characte i no 
availabl o CON:.

     Inputs:  -None-

     Outputs:  A = character typed at CON: (if available)
               Zero Flag is set (Z) if no character is available
               Zero Flag is reset (NZ) if character is available

     Registers Affected:  PSW

     SYSLIB Routines Called:  CST, CIN

     Special Error Conditions:  -None-


11.03 General Input Routines

     Routine Name:  CST
     Function
          Inpu th statu o CON i Registe A  I Rea Dat 
Available A=0 otherwise A=1.

     Inputs:  -None-

     Outputs:  A = Console Status
                   0 --> Read Data Available (RDA)
                   1 --> Read Data Not Available (Not RDA)

     Registers Affected:  PSW

     SYSLIB Routines Called:  -None-

     Special Error Conditions:  -None-



     Routine Names:  CIN, RIN
     Function Inpu characte fro CON (CIN o RDR (RIN i 
Registe A.

     Inputs:  -None-

     Outputs:  A = Character input from CON: or RDR:

     Registers Affected:  PSW

     SYSLIB Routines Called:  -None-

     Special Error Conditions:  -None-



11.04 General Output Routines

     Routine Names:  COUT, LOUT, POUT
     Function
          Outpu characte i Registe  t CON (COUT) LST 
(LOUT) o PUN (POUT).

     Inputs:  A = Character to output

     Outputs:  -None- (Character is output)

     Registers Affected:  -None-

     SYSLIB Routine Called:  -None-

     Special Error Conditions:  -None-


     Routine Names:  CCOUT, CLOUT, CPOUT
     Function
          Outpu characte i Registe  t CON (COUT) LST 
(LOUT) o PUN (POUT wit contro characte processing  Al 
character wit ASCI code les tha <SP (spac  20H i valu 
excep <NULL> <BEL> <BS> <LF> an <CR ar outpu a a 
uparro (^ followe b th correspondin lette generate b 
addin 40 t th characte valu (i.e.  output a "^A"  a 
"^B" etc.)  Again th character les tha <SP i valu NO 
outpu i thi manne ar --

          <NULL>  <BEL>  <BS>  <LF>  <CR>

An characte o valu greate tha <SP i outpu normally.

     Inputs:  A = Character to output

     Outputs:  -None- (Character/Code is output)

     Registers Affected:  PSW (only the Flags;
                              Register A is NOT affected)

     SYSLI Routine Called  COU (fo CCOUT)
                              LOU (fo CLOUT) POU (fo CPOUT)

     Special Error Conditions:  -None-

.fo 12 - Math Routines                                     Page #

12.0 Math Routines

12.01 Introduction

     Thi modul contain  se o 16-bi unsigne arithmeti 
routines  Al routine us H a th accumulato o th result 
an H an D contai th operand require (i onl on operan 
is needed, HL contains it).

     The available routines are:

          ADDHD -- HL = HL + DE    SUBHD -- HL = HL - DE
          MULHD -- HL = HL * DE    DIVHD -- HL = HL / DE
          NEGH  -- HL = 2's Complement of HL
          CMPH  -- HL = 1's Complement of HL
          ROTLH -- HL is rotated left one bit position
          ROTRH -- HL is rotated right one bit position
          SHFTLH -- HL is shifted left one bit position
          SHFTRH -- HL is shifted right one bit position
          ANDHD  -- HL = HL AND DE
          ORHD   -- HL = HL OR DE
          XORHD  -- HL = HL XOR DE



12.02 Arithmetic Operations -- ADDHD, SUBHD, MULHD, DIVHD

     Al o thes routine operat o H an DE placin th 
resul i HL  Th Carr Fla i affected frequentl use t 
indicate overflow.


     Routine Name:  ADDHD
     Function
          HL = HL + DE
     Inputs:  HL, DE are operands
     Outputs:  HL is result, Carry Flag Set (C) means overflow
     Registers Affected:  HL, PSW
     SYSLIB Routines Called:  None
     Specia Erro Conditions  None




     Routine Name:  SUBHD
     Function
          HL = HL - DE
     Inputs:  HL, DE are operands
     Outputs:  HL is result, Carry Flag Set (C) if HL<DE
     Registers Affected:  HL, PSW
     SYSLIB Routines Called:  None
     Specia Erro Conditions  None


     Routine Name:  MULHD
     Function
          HL = HL * DE
     Inputs:  HL, DE are operands
     Outputs:  HL is result, Carry Set means Overflow
     Registers Affected:  HL, PSW
     SYSLIB Routines Called:  SHFTRH, SHFTLH
     Specia Erro Conditions  None
     Note  Thi routin i optimize fo speed wit  mino 
sacrific o size an i alway take 1 loop t perfor an 
multiplication.




     Routine Name:  DIVHD
     Function
          HL = HL / DE
     Inputs:  HL, DE are operands
     Outputs:  HL is result
     Registers Affected:  HL
     SYSLIB Routines Called:  SHFTLH
     Specia Erro Conditions  None
     Note  Thi routin i optimize fo speed wit  mino 
sacrific o size an i alway take 1 loop t perfor an 
division.



12.03 Complement Operations -- NEGH and CMPH

     These routines operate on HL, placing the result into HL.


     Routine Name:  NEGH
     Function
          HL = 2's Complement of HL
     Inputs:  HL is operand
     Outputs:  HL is result
     Registers Affected:  HL
     SYSLIB Routines Called:  CMPH
     Specia Erro Conditions  None




     Routine Name:  CMPH
     Function
          HL = 1's Complement of HL
     Inputs:  HL is operand
     Outputs:  HL is result
     Registers Affected:  HL
     SYSLIB Routines Called:  None
     Specia Erro Conditions  None

12.04 Rotate and Shift Operations -- ROTLH, ROTRH, SHFTLH, SHFTRH


     These operations operate on HL, placing the result into HL.


     Routine Name:  ROTLH
     Function
          H̠ i rotate lef on bi position  Thi i  
circula rotate an th mos significan bi o  i rotate 
into the least significant bit position of L.
     Inputs:  HL is operand
     Outputs:  HL is result
     Registers Affected:  HL
     SYSLIB Routines Called:  None
     Specia Erro Conditions  None




     Routine Name:  ROTRH
     Function
          H̠ i rotate righ on bi position  Thi i  
circula rotate an th leas significan bi o  i rotate 
into the most significant bit position of H.
     Inputs:  HL is operand
     Outputs:  HL is result
     Registers Affected:  HL
     SYSLIB Routines Called:  None
     Specia Erro Conditions  None




     Routine Name:  SHFTLH
     Function
          H̠ i shifte lef on bi position  Th leas 
significant bit of L is filled with a Zero.
     Inputs:  HL is operand
     Outputs:  HL is result
     Registers Affected:  HL
     SYSLIB Routines Called:  None  
     Specia Erro Conditions  None



     Routine Name:  SHFTRH
     Function
          H̠ i shifte righ on bi position  Th mos 
significant bit of H is filled with a Zero.
     Inputs:  HL is operand
     Outputs:  HL is result
     Registers Affected:  HL
     SYSLIB Routines Called:  None  
     Specia Erro Conditions  None




12.05 Logical Operations -- ANDHD, ORHD, XORHD

     These operate on HL and DE, placing the result into HL.


     Routine Name:  ANDHD
     Function
          HL = HL AND DE
     Inputs:  HL and DE are operands
     Outputs:  HL is result
     Registers Affected:  HL
     SYSLIB Routines Called:  None  
     Specia Erro Conditions  None




     Routine Name:  ORHD
     Function
          HL = HL OR DE
     Inputs:  HL and DE are operands
     Outputs:  HL is result
     Registers Affected:  HL
     SYSLIB Routines Called:  None  
     Specia Erro Conditions  None




     Routine Name:  XORHD
     Function
          HL = HL XOR DE
     Inputs:  HL and DE are operands
     Outputs:  HL is result
     Registers Affected:  HL
     SYSLIB Routines Called:  None
     Specia Erro Conditions  None

.fo 13 - CRC Routines                                      Page #

13.0 CRC Routines

     Th CRà Routine ma b use t chec th validit o a 
incomin seria byt strea o arbitrar length  Thes routine 
comput an chec  tru 16-bi Cycli Redundanc Cod (CRC).
     The use of these routines will guarantee detection of:
          1) all single- and double-bit errors
          2) all errors with an odd number of error bits
          3) all burst errors of length 16 or less
     Additionally, the following statistics:
          1) 99.9969% of all 17-bit error bursts
          2) 99.9984% of all possible longer error bursts

     Th followin displa illustrate  typica wa t us thes 
routines:

     ;
     ;  EXTERNAL DECLARATIONS OF SYSLIB ROUTINES
     ;
          ...
          EXT  CRCCLR    ; CLEAR CRC ACCUMULATOR
          EXT  CRCUPD    ; UPDATE CRC ACCUMULATOR
          EXT  CRCDONE   ; RETURN CRC ACCUMULATOR VALUE
          EXT  COMPHD    ; COMPARE HL TO DE, RETURN ZERO IF EQUAL
          ...
     CRC$MAKE:                ; ROUTINE TO ESTABLISH OUTGOING CRC
          CALL CRCCLR    ; CLEAR CRC
          <loop CALLing CRCUPD>    ; ACQUIRE VALUES
          CALL CRCDONE   ; GET VALUE
          PUSH H         ; SAVE VALUE
     CRC$CHECK:          ; ROUTINE TO CHECK INCOMING CRC VALUE
          CALL CRCCLR    ; CLEAR CRC
          <loop CALLing CRCUPD>    ; ACQUIRE VALUES
          CALL CRCDONE   ; GET 2ND CRC
          POP  D         ; GET 1ST CRC IN DE, 2ND IN HL
          CALL COMPHD    ; COMPARE HL TO DE (SYSLIB ROUTINE)
          JNZ  ERROR     ; ERROR IF NO MATCH
          ...

     Th followin scree display describ th CRà routines  
Ther ar thre differen set o CR computatio routines eac 
se workin wit  differen polynomial  Th routin se fo 
CRC use th sam polynomia a th publi domai CRCˠ progra 
b Keit Petersen.

          CRC Routine    Polynomial
          -----------    ----------
             CRC         X^16 + X^12 + X^5 + 1
             CRC1        X^16 + X^15 + X^2 + 1
             CRC2        X^16 + X^15 + X^13 + X^7 + X^4 +
                              X^2 + X + 1



     Routine Name:  CRCCLR, CRC1CLR, CRC2CLR
     Function
          Clea th interna CR Accumulato i preparatio t 
CR computation.

     Inputs:  None

     Outputs:  None

     Registers Affected:  None

     SYSLIB Routines Called:  None

     Special Error Conditions:  None



     Routine Name:  CRCUPD, CRC1UPD, CRC2UPD
     Function:
          Updat th CR Accumulato valu wit th nex byte.

     Input:  A=byte to be included in CRC

     Outputs:  None

     Registers Affected:  None

     SYSLIB Routines Called:  None

     Special Error Conditions:  None



     Routine Name:  CRCDONE, CRC1DONE, CRC2DONE
     Function
          Terminat堠 CRà valu accumulatio an retur th 
calculate 16-bi CR value.

     Inputs:  None

     Output:  HL = calculated CRC value

     Registers Affected:  HL

     SYSLIB Routines Called:  None

     Special Error Conditions:  None











          **** This Page Intentionally Left Blank ****





.fo 14 - Random Number Generator Routines                  Page #

14.0 Random Number Generator Routines

     Th followin se o routine ar use t (1 provid  see 
valu fo th rando numbe generato an (2 cal  rando 
number generator to return a random number.

     RNDINIԠ counts waitin fo th user' keypress a whic 
poin i stop countin an use th coun a th see valu fo 
the random number generator.

     RNDSEEĠ allow th use t specif  see valu fo th 
random number generator.

     RND returns a random number.


     Routine Name:  RNDINIT
     Function
          RNDINI enter  countin loop waitin fo th use t 
strik  ke a hi console  I the set th see valu fo th 
rando numbe generato base upo it coun valu a th instan 
of keypress.  The seed value is an 8-bit quantity.

     Inputs:  None (User Keypress)

     Outputs:  None  (Seed is set)

     Registers Affected:  None

     SYSLIB Routines Called:  CONDIN, RND

     Specia Erro Conditions  None




     Routine Name:  RNDSEED
     Function
          Thi routin allow th use t provid  see valu 
fo th rando numbe generator  Th see i passe i th  
register.

     Inputs:  A = Seed

     Outputs:  None  (Seed is set)

     Registers Affected:  None

     SYSLIB Routines Called:  RND

     Specia Erro Conditions  None




     Routine Name:  RND
     Function
          Thi i th user-callabl rando numbe generator  I 
return  pseudo-rando numbe (8-bit i th  registe whe 
called.

     Inputs:  None

     Outputs:  A = Random Number

     Registers Affected:  PSW

     SYSLIB Routines Called:  None

     Specia Erro Conditions  None


.fo 15 - User/Disk Manipulation Routines                   Page #

15.0 User/Disk Manipulation Routines

     Thi i  se o fou routine whic allo th use t 
readil mov aroun betwee disk an use areas  Thes routine 
are:
          PUTUD -- to save away the current disk/user
          GETUD -- to restore the disk/user saved by PUTUD
          RETUD -- to return the current disk/user
          LOGUD -- to log the user into a specified disk/user

     PUTUĠ an GETU ar designe t b use a  plac marke 
an retur combination  The ar intende t b use i cod 
sequences like the following:

          CALL PUTUD     ; Mark current location
          < move around on disks/users >
          CALL GETUD     ; Return to marked location

     RETU an LOGU ar t b use t fin ou wher th progra 
is (RETUD) and to enter a specific disk/user area (LOGUD).



     Routine Name:  PUTUD
     Function
          PUTUĠ save th curren use an dis number awa fo 
late retrieva b GETUD  PUTU an GETU ar intende t b 
use t sav an restor th curren dis an use aroun som 
set of operations in another user/disk area.

     Inputs:  None

     Outputs:  None

     Registers Affected:  None

     SYSLIB Routines Called:  RETUD

     Specia Erro Conditions  None




     Routine Name:  GETUD
     Function
          GETUĠ restore th curren use an dis whic wa 
saved by PUTUD.

     Inputs:  None

     Outputs:  None

     Registers Affected:  None

     SYSLIB Routines Called:  BDOS

     Specia Erro Conditions  None



     Routine Name:  LOGUD
     Function
          LOGU log i th dis specifie b th  registe (B= 
fo Dis A) and the user specified by the C register.

     Inputs:  B=Disk (B=0 for Disk A), C=User

     Outputs:  None

     Registers Affected:  None

     SYSLIB Routines Called:  BDOS

     Specia Erro Conditions  None




     Routine Name:  RETUD
     Function
          RETUĠ return th number o th curren use i  an 
current disk in B (B=0 for disk A).

     Inputs:  None

     Outputs:  B=Disk (B=0 for disk A), C=User

     Registers Affected:  BC

     SYSLIB Routines Called:  BDOS

     Specia Erro Conditions  None


.fo 16 - Sort Routines                                     Page #

16.0 Sort Routine 

     Tw routine ar provide whic giv th SYSLI  programme 
acces t  ver flexibl sortin system  Th mai routin i 
calle SORT an i provide  utilit whic doe a in-memor 
sor o  se o fixed-lengt records  Th sortin techniqu 
use i  Shel Sort adapte fro th boo "Softwar Tools b 
Kerniga an Plaugher publishe b Addison-Wesly 1976 pag 
106  Thi sor i ver fast muc mor s tha th simpl bubbl 
sort.

     Thi Shel Sor ca b don i tw ways  wit o withou 
usin pointers  Sortin withou usin pointer i typicall 
slowe tha sortin wit pointers an th onl advantag t no 
usin pointer i th saving o spac whic i take u b th 
pointer (2*numbe o entrie bytes)  I pointer ar use fo 
th sort the wheneve a exchang i done th pointer ar 
simpl exchanged rathe tha th ful records an thi greatl 
decreases the sort time in most cases.

     Th SOR routin i controlle b passin t i  pointe t 
 Sor Specificatio Bloc (SSB i DE  Thi Sor Specificatio 
Bloc i  serie o 2-byt word whic contai th followin 
information:

          Bytes 0&1: Starting Address of 1st Record
          Bytes 2&3: Number of Records to Sort
          Bytes 4&5: Size of Each Record (in Bytes)
          Bytes 6&7: Address of Compare Routine Provided by User
                         Thi routin compare tw records on 
pointe t b H an th othe pointe t b 
DE  I th recor pointe t b D i les 
i sortin orde tha tha pointe t b HL 
thi Compar Routin i t retur wit Carr 
Se (C)  I th record ar equa i 
sortin order thi Compar Routin i t 
retur wit Zer Se (Z)  Onl th PSנ i 
to be affected by the Compare Routine.
          Bytes 8&9: Address of Pointer Table
          Byt 10  Flag FFH mean t us pointers 0 mean not
          Byte 11:  Unused

     A mentione previously tw routine ar availabl i thi 
sor module  Th firs routine SSBINIT look a th beginnin 
o  scratc are an th initia content o a SS  an 
allocate spac fo th pointe table  I als check t se i 
th buffe require wil overflo th TP (Transien Progra 
Area).

     Th secon routine SORT perform th sort an controlle 
by the SSB pointer passed to it in DE.


     Routine Name:  SSBINIT
     Function
          Thi routin load byte 0& (addres o firs record 
an 8& (addres o pointe table o a SSB checkin fo TP 
overflow  I i passe th star addres o  scratc area an 
set th pointe tabl t star here look a th recor siz 
an recor coun entrie o a SSB an add thi produc t th 
addres o th pointe table  Th resultan addres i returne 
as the address of the first record.
     Thi routin ma b use a describe abov befor an 
record ar loade int memor fo th sort o i ma b use 
afte th record hav alread bee loaded  I th latte case 
th use shoul sav th star addres o th firs recor an 
cal SSBINIԠ wit th addres o th firs byt afte th las 
record  Onc SSBINIԠ ha loade th buffer i th SS  an 
checke fo  TP overflo (not tha thi i don fo th 
pointer only) i wil retur t th caller a whic tim th 
calle shoul restor th firs tw byte o th SS  t thei 
proper values, the actual start address of the first record.

     Inputs:  HL pts to start of scratch area, DE pts to SSB

     Outputs:  Z Flag is Set (Z) if TPA overflow; NZ if OK

     Registers Affected:  PSW

     SYSLIB Routines Called:  MOVEB

     Specia Erro Conditions  None




     Routine Name:  SORT
     Function
          SOR sort th se o fixe lengt record accordin t 
th contro informatio i th Sor Specificatio Bloc (SSB 
pointed to by DE.

     Inputs:  DE pts to SSB

     Outputs:  None (Records are Sorted)

     Registers Affected:  None

     SYSLIB Routines Called:  MOVEB, PRINT

     Specia Erro Conditions
          Th Erro Messag "SOR Pointe Error ma b printed 
bu i highl unlikely  Thi indicate  fla ha develope wit 
th SOR routin fo thi particula case an i coul no SOR 
th se o record a desired  Thi erro i fata an wil 
abort to CP/M.
.fo 17 - ZCPR2 Feature-Specific Routines                   Page #

17.0 ZCPR2 Feature-Specific Routines

     Thi modul contain  serie o routine whic ar designe 
t allo th programme t tak advantag o ke ZCPR Feature 
withou doin  lo o programmin fo himself  I particular 
facilitie suc a th followin ar provided:

  ZINIMC  -  Initializatio -- Settin th locatio o the
                    multiple command line buffer
  ZINIEXT -  Initialization -- Defining the location of a command
                    search path
  ZINICI  -  Initialization -- Setting the current disk/user
                    character definition
  ZINIDMA -  Initialization -- Set the DMA address for ZCPR2 disk
                    Input/Output
  ZGPINS  -  Initialization -- Setting all ZCPR2 buffers as
                    required from buffers set up as per the
                    ZCPR2 Utility Standard General Purpose
                    Installation Format
  ZCPR   -  Utilit -- Returnin  pointe t th interna 
                    buffers of the first ZCPR2 SYSLIB Module
  ZMCPTR  -  Utility -- Returning a pointer to the first byte
                    of the next command
  ZPFIND  -  Utility -- Searching for a file along the command
                    search path
  ZFSTAT  -  Utility -- Determining the attributes of a file

      not o statu routines  ther ar thre module i 
SYSLI  whic contain ZCPR2-specifi routines  On modul 
contain jus ZGPIN an contain n statu retur routine bu 
th othe tw module contai ZCPR an ZCPRQ2 resp t retur 
pointer t importan interna buffer a describe i thi 
manual  Thi chapte describe th firs ZCPR module an it 
status routine is ZCPRQ.


     Routine Name:  ZINIMC
     Function
          ZINIM define th bas addres o th multipl comman 
lin buffe fo th ZCPR system  Th initializatio performe 
b thi routin i use b th ZMCPT routin t retur th 
pointer to the first character of the next command.

     Inputs:  HL = base address of multiple command line buffer
     Outputs:  None
     Registers Affected:  None
     SYSLIB Routines Called:  None
     Specia Erro Conditions  None

     Note  I thi routin i no called i i assume tha 
multiple command lines are not supported.



     Routine Name:  ZINIEXT
     Function
          ZINIEXԠ define th bas addres o  comman searc 
path  Th ZPFINĠ routin use thi bas addres t star it 
searc fo  file  Not tha thi provide adde flexibilit i 
tha thi nee no necessaril b th bas addres o th ZCPR 
Syste comman searc path bu i ma b th bas addres o an 
path (such as a separate path to look for HLP files).

     Inputs:  HL = base address of path

     Outputs:  None

     Registers Affected:  None

     SYSLIB Routines Called:  None

     Specia Erro Conditions  None

     Note  I thi routin i no called th externa pat 
default t a empt path s n har i don an n searc ca 
b performed.


     Routine Name:  ZINICI
     Function
          ZINICɠ define th characte use t indicat th 
curren use o dis i th ZCPR comman searc path  Thi 
characte i passe i A  I thi routin i no called th 
ZCPR2 default of '$' is assumed.
     Inputs:  A = Current Indicator
     Outputs:  None
     Registers Affected:  None
     SYSLIB Routines Called:  None
     Specia Erro Conditions  None
     Note  I thi routin i no called Curren Indicato 
defaults to '$'.


     Routine Name:  ZINIDMA
     Function
          ZINIDM define th DM addres use fo al dis Inpu 
an Output  Thi addres i passe i HL  I thi routin i 
no called th ZCPR defaul o 80 i assumed.
     Inputs:  HL = DMA Address
     Outputs:  None
     Registers Affected:  None
     SYSLIB Routines Called:  None
     Specia Erro Conditions  None
     Note  I thi routin i no called DM Addres default 
t 80H.


     Routine Name:  ZGPINS
     Function
          ZGPINӠ initialize th ZCPR2-Specifi Buffer fro th 
ZCPR Utilit Standar General-Purpos Installatio Forma Buf
fers  Thi i t b use b ZCPR Utilities suc a XDIR3 t 
completel initializ al th necessar buffers.
     Th buffer i th utilitie ar locate a indicate i th 
ZCPR Utilitie Manual.

     Inputs:  None

     Outputs:  None

     Registers Affected:  None

     SYSLIB Routines Called:  MOVEB, ZINIMC, ZINIEXT, ZCPRSET,
                              ZFNINIT

     Specia Erro Conditions  None





     Routine Name:  ZCPRQ
     Function
          ZCPRѠ querie th statu o th SZCPҠ module whic 
contain thes routines  O exit thi routin return  pointe 
t th interna buffer o th firs ZCPR modul i SYSLIB  
These buffers are structured as follows:
		Byte 0:  Multiple command available flag (0=no)
		Bytes 1-2:  Address of multiple command line
				buffer, if available
		Bytes 3-4:  Address of external path (empty
				path if path not set)
		Byte 5:  Current User/Disk Indicator
		Bytes 6-7:  DMA Address

     Inputs:  None
     Outputs:  HL = Base Address of Buffers
     Registers Affected:  HL
     SYSLIB Routines Called:  None
     Specia Erro Conditions  None


     Routine Name:  ZMCPTR
     Function
          ZMCPTҠ return  pointe t th nex characte i th 
multipl comman lin i multipl command ar enabled   fla 
is returned which says if multiple commands are enabled or not.

     Inputs:  None

     Outputs:  HL pts to next char in line
               A=0 and Zero Flag Set (Z) if multiple commands
                    are not available; NZ otherwise

     Registers Affected:  HL, PSW

     SYSLIB Routines Called:  None

     Specia Erro Conditions  None




     Routine Name:  ZPFIND
     Function
          ZPFINĠ searche fo  fil alon th comman searc 
pat whos bas addres wa define whe th programme calle 
ZINIEXT  I log int eac dis an use are alon th path 
lookin fo th fil whos FC i pte t b DE unti i eithe 
find th fil o reache th en o th pat (fil no found)  
I th fil i found i return th dis an use are i whic 
th fil resides  ZPFIN alway return th proces t th dis 
and user area it is "currently" logged into.

     Inputs:  DE pts to the FCB of the file to find
              B is a flag; if B <> 0, search the current disk and
                    user area first; if B=0, do not search the
                    current disk and user area first

     Outputs:  Zero Flag Clear (NZ) and A=0FFH if file found
               B = Disk (B=0 if Disk A), C=User if file found
               Zero Flag Set (Z) and A=0 if file not found

     Registers Affected:  BC, PSW

     SYSLIB Routines Called:  BDOS

     Specia Erro Conditions  None


     Routine Name:  ZFSTAT
     Function
          ZFSTAԠ determine th attribute o th fil i th 
curren dis an use are whos FC i pte t b DE  I tell 
the programmer if the file is SYSTEM or not and READ/ONLY or not.

     Inputs:  DE pts to FCB of file

     Outputs:  B=0 means file is NOT System, B<>0 means file is
               C=0 means file is NOT R/O, C<>0 means file is
               Zer Fla Se (Z an A= i fil foun an BC
                    valid, and Zero Flag Clear (NZ) if file not
                    found

     Registers Affected:  BC, PSW

     SYSLIB Routines Called:  BDOS

     Specia Erro Conditions  None

     Note:  ZFSTAT does NOT do a search.


.fo 18 - ZCPR2-Specific Named Directory Routines           Page #

18.0 ZCPR2-Specific Named Directory Routines

     Thi se o routine i specifi t th ZCPR2-Specifi Name 
Director Structure  Thes routine provid th programme wit 
 se o routine whic resolv th name director reference 
fo him translatin  name director int th disk/use are i 
refers to.

     Five routines are included in this set:
          o ZCPRQ2 -- Return Status
          o ZFNINIT -- Initialize Named Directory Buffers
          o ZDNFIND -- Scan for Disk Directory Name
          o ZDNAME -- Load All Disk Directory Name Data
          o ZFNAME -- Named Directory File Name Scanner


     Routine Name:  ZCPRQ2
     Function:
          ZCPRQ i th companio t ZCPRQ an i return  
pointe t th interna buffer o th secon ZCPR modul whic 
contains such buffers.  The organization of these buffers is:

               Byte 0:  Max Number of Named Directory Entries
               Bytes 1-2:  Address of memory-resident named
                              directory buffer (or 0 if none)
               Bytes 3-38:  FCB of NAMES.DIR

     Inputs:  None
     Outputs:  HL points to first byte of buffer
     Registers Affected:  HL
     SYSLIB Routines Called:  None
     Special Error Conditions:  None


     Routine Name:  ZFNINIT
     Function
          ZFNINIԠ allow th use t specif th addres o th 
memory-residen name director buffer initializ th nam o 
th name director fil (defaul nam o NAMES.DIR t som 
othe name an t chang th numbe o name permitte i  
director fil (defaul o 64).

     Inputs:  DE pts to FCB containing the new file name
              HL contains address of memory-resident buffer
              C is the new maximum number of directory names
              A is a flag indicating values to set as follows:
                    Bit 7 -- Set to 1 to load default FCB fm DE
                    Bit 6 -- Set to 1 to load name count fm C
                    Bit 5 -- Set to 1 to load address fm HL
     Outputs:  None
     Registers Affected:  None
     SYSLIB Routines Called:  MOVEB
     Specia Erro Conditions  None

     Routine Name:  ZDNAME
     Function:
          ZDNAMŠ load th content o th NAMES.DIҠ fil int 
th memor buffe pointe t b HL  Eac entr i thi buffe i 
structured as follows:
               Byte 0:  Disk Number (A=0)
               Byte 1:  User Number
               Bytes 2-9:  Directory Name, 8 Chars Max, Space
                    Fill at End

     Inputs:  HL pts to the memory buffer extending to the base
               of the BDOS

     Outputs:  HL pts to the first entry in the buffer
               C is the number of valid entries, B=0
               A is the error flag (A=0 and Z if error)

     Registers Affected:  HL, BC, PSW

     SYSLIB Routines Called:  INITFCB, ZPFIND, FI3$OPEN, F3$GET

     Special Error Conditions:  None





     Routine Name:  ZDNFIND
     Function
          ZDNFIN examine th DIR prefi fo eithe  DU for 
o  director name  I i i determine tha th DIR prefi i 
no o th DU form the th memory-residen director buffe i 
scanned i present and failin that th NAMES.DI fil i 
sough alon th ZCPR path loaded an scanne fo  corres
pondin name  I found th correspondin use an dis value 
ar returned i no found a erro cod i returned.

     Inputs:  HL pts to first byte of DIR: prefix
              A= i DU for NO allowed

     Outputs:  B=Disk (B=1 if Disk A, B=0FFH if Current Disk),
               C=User (C=0FFH if Current User), HL pts to colon,
               Zer Fla Clea (NZ i n error Zer Fla Se 
               (Z) if error, and no valid values returned

     Registers Affected:  BC, HL, PSW
     SYSLIB Routines Called:  INITFCB, ZPFIND, FI3$OPEN,
                              FI3$CLOSE, F3$GET

     Specia Erro Conditions  Not tha ZDNFIN use Inpu Fil 
3 s Inpu Fil  shoul no b opene whe thi routin i 
called  Also ZPFIN i used s th programme mus b sur  
proper external path is specified if needed by calling ZINIEXT.

     Routine Name:  ZFNAME
     Function
          ZFNAMŠ i  fil nam scanner  Pointin t th firs 
characte o栠 ᠠ fil nam堠 specificatio o栠 th堠 for 
'DIR:FILENAME.TYP' wher an par o thi specificatio i 
optional thi routin fill i a FC  wit zeroes properl 
initialize th F an F (Fil Nam an Fil Type field i 
'FILENAME.TYP o an par thereo i present an return th 
valu o dis an use i the ar specifie (o 0FF i not).
     Th director indicato 'DIR:' i specified ma b o on 
of four forms:
          DIRECT: -- A named directory, of up to 8 chars long
          d:      -- A disk drive letter
          u:      -- A user number
          du:     -- A disk drive letter and a user number
     Th du for i checke first s unnecessar dis activit 
in looking for the NAMES.DIR file is avoided.
     Examples of valid input strings:
          HELP:*.HLP     A5:TEST.TXT    C?:ABC.*  PASCAL:*.COM

     Inputs:  DE pts to FCB to fill, HL pts to first byte of
               targe string; FCB is 36 bytes long

     Outputs:  B=Disk (B=1 for Disk A), C=User
               B=0FFH if no disk specified (current disk)
               C=0FFH if no user specified (current user)
               C=? if all user areas specified
               HL pts to terminating character
               A=0 and Zero Flag Set (Z) if error in disk
                    or user numbers; A=0FFH and NZ if no error

     Registers Affected:  BC, HL, PSW

     SYSLIB Routines Called:  ZDNFIND

     Specia젠 Erro Conditions  Se堠 FNAMŠ routin堠 fo 
similarities


.fo 19 - Miscellaneous Routines                            Page #

19.0 Miscellaneou Routine 

     Thi sectio describe th followin Miscellaneou Routines:


          BDOS      For Direct BDOS Interface
          BIOS      For Direct BIOS Interface
          CAPS      For Character Capitalization
          CAPSTR    For String Capitalization
          CATH      Convert ASCII Character to Hexadecimal
          CLINE     Save Command Line Buffer
          CODEND    Provide End of Code/Data Area
          EN        Exchange Nybbles in A
          FILLB     Fill Memory (up to 255 bytes)
           FILLBC   Fill Memory (up to 65,535 bytes)
           HFILB    Fill Memory (up to 255 bytes)
           HFILBC   Fill Memory (up to 65,535 bytes)
          MOVEB     Move Memory (up to 255 bytes)
           MOVEBC   Move Memory (up to 65,535 bytes)
           HMOVB    Move Memory (up to 255 bytes)
           HMOVBC   Move Memory (up to 65,535 bytes)
          PAUSE     Delay N 10ths of a Second
          VERSION   Return Version Number of SYSLIB


     Routine Name:  BDOS
     Function
          Cal CP/͠ Entr Poin a locatio  an preserv 
Register DE an BC.

     Inputs:  C and DE provide input parameters

     Outputs:  A and HL provide output parameters

     Registers Affected:  PSW, HL

     SYSLIB Routines Called:  -None-

     Special Error Conditions:  -Determined by Routines Called-



     Routine Name:  BIOS
     Function
          BIO provide th use wit  direc interfac int th 
CP/͠ BIOS  I i calle wit th  Re containin th inde 
offse int th BIO JM table  N register ar preserve b 
thi routine  Th content o HL DE an B ar passe t th 
BIOS unchanged.

     The following table summarizes the BIOS JMP Table Entries --

   Offset Function
      0   Cold Start
      1   Warm Start
      2   Console Status; Returns A=0FFH if char ready, A=0 if
               not
      3   Console Input; Returns char in A
      4   Console Output; Char passed in C
      5   List Output; Char passed in C
      6   Punch Output; Char passed in C
      7   Reader Input; Returns char in A

      8   Home Disk Head (Return Version Number); Returns
               Version Number in HL
      9   Select Disk; Disk Number (A=0, etc) passed in C
     10   Set Track Number; Track Number passed in C
     11   Set Sector Number; Sector Number passed in C
     12   Set DMA Address; DMA Address passed in BC
     13   Read Block from Disk; Returns A=0 if OK, A=1 if Error
     14   Write Block to Disk; Returns A=0 if OK, A=1 if Error

     15   List Status; Returns A=0FFH if ready to output, A=0
               if not
     16   Sector Translation; Logical-to-Physical Sector
               Translation; Logical Sector Number passed in BC
               and Translate Table Address passed in DE; Returns
               Physical Sector Number in HL


     Inputs:  A = Offset (as per Table Above)
              BC = Input Parameters

     Outputs:  A, HL = Output Parameters

     Registers Affected:  All

     SYSLIB Routines Called:  -None-

     Special Error Conditions:  -None-



     Routine Name:  CAPS
     Function
          Capitaliz ASCIɠ characte i Registe  i i i 
lower-cas alphabeti (a-z) otherwise retur  unaffected  
Onl th lowe seve bit o th byt ar considered an th 
Mos Significan Bi i maske ou t zero.

     Inputs:  A = character to capitalize

     Outputs:  A = capitalized character

     Registers Affected:  PSW

     SYSLIB Routins Called:  -None-

     Special Error Conditions:  -None-



     Routine Name:  CAPSTR
     Function:
          CAPST capitalize th <NULL>-terminate strin pointe 
to by HL.  No Registers are affected.

     Inputs:  HL pts to first byte of string

     Outputs:  None (String is Capitalized)

     Registers Affected:  None

     SYSLIB Routines Called:  CAPS

     Special Error Conditions:  None



     Routine Name:  CATH
     Function
          Conver th ASCIɠ Hexadecima characte i th  
Registe t binar i th  Register  I invali characte (no 
0-9 A-F) retur <SP (2 Hex i  Registe a erro code.

     Input:  A = ASCII Hex Character (0-9, A-F)

     Output:  A = Binary value represented by char

     Registers Affected:  PSW

     SYSLIB Routines Called:  -None-
     Specia Erro Conditions:
          I invali he char <SP (2 Hex returne i  
Register.



     Routine Name:  CLINE
     Function:
          T sav th comman lin buffe pte t b H awa i 
a interna buffe a  string  Th characte coun i pointe 
t b H (lik th buffe a 80 se b ZCPR an CP/ 2.2) an 
th buffe content (no includin th characte count i save 
awa a  null-terminate string  Thi routin return wit H 
pointing to the first character of this string.

     Inputs:  HL points to command line

     Outputs:  HL points to first character of string

     Registers Affected:  HL

     SYSLIB Routines Called:  -None-
     Special Error Conditions:  -None-



     Routine Name:  CODEND
     Function
          Retur th addres o th nex pag followin th las 
byt o code  Thi i usefu i determinin wher th scratc 
are begins.

     Inputs:  None

     Output:  HL=Address of next page

     Registers Affected:  HL

     SYSLIB Routines Called:  -None-
     Special Error Conditions:  -None-

     Routine Name:  EN
     Function
          Exchang Nybble i Registe A High-orde fou bit 
ar exchange wit Low-orde fou bit o Registe A.

     Inputs:  A = Byte input

     Outputs:  A = Byte output

     Registers Affected:  PSW

     SYSLIB Routines Called:  -None-

     Special Error Conditions:  -None-



     Routine Names:  FILLB, FILLBC, HFILB, HFILBC
     Function
          Thes routine fil a are o memor wit  constan 
byt value  FILL ca fil u t  256-byt buffer an FILLB 
ca fil u t  65,536-byt (withi reason buffer.
     FILL  an FILLB hav n effect o an registers  HFIL 
an HFILB bot affec th H registe pair an the retur wit 
H̠ pointin t th byt afte th las byt filled  HFIL  an 
HFILBà ar usefu whe furthe processin fro th las poin 
filled is desired.

     Inputs:  HL points to the first byte of the buffer
              B (for FILLB) or BC (for FILLBC) = number of bytes
               in buffer
              A = byte value to fill buffer with

     Outputs:  None for FILLB and FILLBC (Buffer is filled)
               H point t nex byt fo HFIL an HFILBC

     Registers Affected:  None for FILLB, FILLBC; HL for HFILB,
                              HFILBC

     SYSLIB Routines Called:  -None-

     Special Error Conditions:  -None-



     Routine Names:  MOVEB, MOVEBC, HMOVB, HMOVBC
     Function
          Mov th bloc o memor pointe t b H t th memor 
locatio pointe t b DE  MOVE ca mov u t  256-byt 
buffer an MOVEB ca mov u t  65,536-byt buffer.

     MOVE  an MOVEB hav n effect o an registers  HMOV 
an HMOVB bot affec th H registe pair an the retur wit 
H an D pointin t th byt afte th las byt moved  HMOV 
an HMOVB ar usefu whe furthe processin fro th las poin 
fille i desired.


     Inputs:  HL points to the 1st byte of the buffer to move
              DE points to the 1st byte of the buffer to move to
              B (for MOVEB) or BC (for MOVEBC) = number of bytes
               in buffer

     Outputs:  None for MOVEB and MOVEBC (Buffer is moved)
               HL and DE pt to byte after last byte moved for
                    HMOVB and HMOVBC

     Registers Affected:  None for MOVEB, MOVBC; HL, DE for
                              HMOVB, HMOVBC

     SYSLIB Routines Called:  -None-

     Special Error Conditions:  -None-




     Routine Name:  PAUSE
     Function:
          Delay N 10ths of a Second.
     Inputs:  HL = N (Number of 10ths of a Second Delay desired)
              B = Processor Speed in MHz (1, 2, 3, 4, ...)
     Outputs:  None (Routine returns N 10ths of a Second later)
     Registers Affected:  None
     SYSLIB Routines Called:  None
     Special Error Conditons:  None




     Routine Name:  VERSION
     Function:
          Return Version Number of SYSLIB.
     Inputs:  None
     Outputs:  HL = Version Number (H=Major, L=Minor)
     Registers Affected:  HL
     SYSLIB Routines Called:  None
     Special Error Conditons:  None
.fo 20 - Cross-Reference Listing of SYSLIB Routines        Page #

20.0 Cross-Reference Listing of SYSLIB Routines

Symbol	Defined	Referenced

ADDHD   SMATH
ADRCPY  SFILEI  S0FILE  S1FILE  S2FILE  S3FILE  
ANDHD   SMATH

BBLINE	SBBLIN
BDOS    SBODS   SZFNAM  SZCPR   SFOPEN  SFEXIS  SFMAKE
                SFCLOS  SRENAM  SFREAD  SFWRIT  SFDEL
                SUD
BIOS    SBIOS   
BLINE	SBLINE

CAPS    SCAPS   SZFNAM  SFNAME  SEVAL   SEVAL2  SBBLIN
                SBLINE  SCAPST  
CAPSTR  SCAPST  
CATH    SCATH   
CCOUT	SCCOUT	SINLIN	SPSTR
CIN     SCIN    SCONDI  SINLIN  
CLINE   SCLINE
CLOUT	SCLOUT	SLPSTR
CMPH    SMATH
CODEND  SCODEN  
COMPB   SCOMP   
COMPBC  SCOMP   
COMPHD  SCOMPH  
CONDIN  SCONDI  SRAND
COUT	SCOUT	SINLIN	SPSTR	SPHL5D	SPA2HC	SPADC
			SCRLF	SCCOUT
CPOUT   SCPOUT  
CRC1CL  SCRC1   
CRC1DO  SCRC1   
CRC1UP  SCRC1   
CRC2CL  SCRC2
CRC2DO  SCRC2
CRC2UP  SCRC2
CRCCLR  SCRC    
CRCDON  SCRC    
CRCUPD  SCRC    
CRLF	SCRLF	SINLIN
CST     SCST    SCONDI  

DBUFFE  SDIR
DFREE	SDIR
DIRALP	SDIR
DIRF	SDIR
DIRFS	SDIR
DIRLOA	SDIR
DIRNPA	SDIR
DIRPAC	SDIR
DIRSEL	SDIR
DIRSLO	SDIR
Symbol	Defined	Referenced

DIVHD   SMATH
DPARAM  SDIR    

EN      SEN     SMA2HC  SLA2HC  SPA2HC  
EVAL    SEVAL   
EVAL10  SEVAL1  SEVAL   
EVAL16  SEVAL2  SEVAL   
EVAL2   SEVAL4  SEVAL   
EVAL8   SEVAL3  SEVAL   

F$CLOS	SFCLOS
F$DELE	SFDEL	SFMAKE
F$EXIS  SFEXIS
F$GET   SFILEI  S0FILE  S1FILE  S2FILE  S3FILE  
F$MAKE	SFMAKE
F$MOPE	SFOPEN	SFILEI
F$OPEN	SFOPEN	SFILEI
F$PUT   SFILEI  S0FILE  S1FILE  S2FILE  S3FILE  
F$READ	SFREAD
F$RENA  SRENAM
F$WRIT	SFWRIT

F0$GET  S0FILE  
F1$GET	S1FILE  
F2$GET  S2FILE  
F3$GET  S3FILE  SZFNAM
F0$PUT  S0FILE  
F1$PUT  S1FILE  
F2$PUT  S2FILE  
F3$PUT  S3FILE  
FI$CLO  SFILEI  S0FILE  S1FILE  S2FILE  S3FILE  
FI0$CL  S0FILE  
FI1$CL  S1FILE  
FI2$CL  S2FILE
FI3$CL  S3FILE  SZFNAM
FI$OPE  SFILEI  S0FILE  S1FILE  S2FILE  S3FILE  
FI0$OP  S0FILE  
FI1$OP  S1FILE  
FI2$OP  S2FILE  
FI3$OP  S3FILE  SZFNAM

FILLB	SFILL	SINITF
FILLBC  SFILL   
FNAME   SFNAME  


Symbol	Defined	Referenced

FO$CLO  SFILEI  S0FILE  S1FILE  S2FILE  S3FILE
FO$OPE  SFILEI  S0FILE  S1FILE  S2FILE  S3FILE  
FO0$CL  S0FILE  
FO1$CL  S1FILE  
FO2$CL  S2FILE  
FO3$CL	S3FILE
FO0$OP  S0FILE  
FO1$OP  S1FILE  
FO2$OP  S2FILE  
FO3$OP	S3FILE

FSIZE   SDIR    

GETUD   SUD

HFILB	SFILL   
HFILBC  SFILL   
HMOVB   SMOVE   
HMOVBC  SMOVE   

INITFC	SINITF	SFIELI  SZFNAM
INLINE	SINLIN
INSTR   SINSTR  

LA2HC	SLA2HC	SLHL4H
LA3DC	SLADC
LADC	SLADC
LCRLF   SLCRLF  
LHL4HC	SLHL4H
LHL5DC	SLHL5D
LHLDC	SLHL5D
LOGUD   SUD
LOUT	SLOUT	SLPSTR	SLHL5D	SLA2HC	SLADC	SLCRLF
			SCLOUT
LPRINT	SLPRIN
LPSTR	SLPSTR	SLPRIN

MA2HC   SMA2HC  SMHL4H  
MA3DC   SMADC   
MADC    SMADC   
MHL4HC  SMHL4H  
MHL5DC  SMHL5D  
MHLDC   SMHL5D  
MOVEB   SMOVE   SZFNAM  SSORT   SRENAM  SZGPIN
MOVEBC  SMOVE   
MULHD   SMATH

NEGH    SMATH

ORHD    SMATH


Symbol	Defined	Referenced

PA2HC   SPA2HC  SPHL4H  
PA3DC   SPADC   
PADC    SPADC   
PAUSE   SPAUSE  
PHL4HC  SPHL4H  
PHL5DC  SPHL5D  
PHLDC   SPHL5D  
POUT    SPOUT   SCPOUT  
PRINT   SPRINT  SDIR    SSORT   SRAND
PSTR    SPSTR   SPRINT  
PUTUD   SUD

RETUD   SUD
RIN     SRIN    
ROTLH   SMATH
ROTRH   SMATH
RND     SRAND
RNDINI  SRAND
RNDSEE  SRAND

SCANNE  SSCANN  
SHFTLH  SMATH
SHFTRH  SMATH
SORT    SSORT   
SSBINI  SSORT
SUBHD   SMATH

VERSIO  SVERSI

XORHD   SMATH

ZCPRQ   SZCPR
ZCPRQ2  SZFNAM
ZDNAME  SZFNAM
ZDNFIN  SZFNAM
ZFNAME  SZFNAM
ZFNINI  SZFNAM  SZGPIN
ZFSTAT  SZCPR
ZGPINS  SZGPIN
ZINICI  SZCPR   SZGPIN
ZINIDM  SZCPR   SZGPIN
ZINIEX  SZCPR   SZGPIN
ZINIMC  SZCPR   SZGPIN
ZMCPTR  SZCPR
ZPFIND  SZCPR   SZFNAM

.fo 21 - Sample Programs Using SYSLIB                      Page #

.FI SYSLIBS.WS

